<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <html>
            <head>
                <title>Server View RAID Manager - RAID Log</title>
                <meta name="copyright" content=" Fujitsu Technology Solutions 2009" />
	            <meta name="author" content="Fujitsu Technology Solutions" />
            </head>
            <body style="font-family:Verdana, Arial, Helvetica, sans-serif">
                <h1 style="font-size:100%">Server View RAID Manager - RAID Log</h1>
                <table width="100%">
                    <tr>
                        <td>
                            <table width="100%" style="font-size:80%; background-color:#E0F3F5; color:black; border:1px solid black">
                                <tr>
                                    <th align="left" width="10%">Event ID</th>
                                    <th align="left" width="10%">Date</th>
                                    <th align="left" width="10%">Time</th>
                                    <th align="left" width="20%">Severity</th>
                                    <th align="left" width="50%"></th>
                                </tr>
                                <tr>
                                    <th align="left" colspan="5" style="background-color:white">Event Source</th>
                                </tr>
                                <tr>
                                    <th align="left" colspan="5" style="background-color:white">Description</th>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <xsl:for-each select="EventLog/Event">
                        <tr>
                            <td>
                                <table width="100%" style="font-size:80%; background-color:#E0F3F5; color:black; border:1px solid black">
                                    <tr>
                                        <td align="left" width="10%">
                                            <xsl:value-of select="@EventID" />
                                        </td>
                                        <td align="left" width="10%">
                                            <xsl:value-of select="@Date" />
                                        </td>
                                        <td align="left" width="10%">
                                            <xsl:value-of select="@Time" />
                                        </td>
                                        <xsl:choose>
                                            <xsl:when test="@Severity = 'ERROR' ">
                                                <td align="left" width="20%" style="color:red; font-weight:bold">
                                                    <xsl:value-of select="@Severity" />
                                                </td>
                                            </xsl:when>
                                            <xsl:when test="@Severity = 'WARNING' ">
                                                <td align="left" width="20%" style="color:orange">
                                                    <xsl:value-of select="@Severity" />
                                                </td>
                                            </xsl:when>
                                            <xsl:when test="@Severity = 'INFORMATION' ">
                                                <td align="left" width="20%" style="color:green">
                                                    <xsl:value-of select="@Severity" />
                                                </td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td align="left" width="20%">
                                                    <xsl:value-of select="@Severity" />
                                                </td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <td width="50%"></td>
                                    </tr>
                                    <tr>
                                        <td align="left" colspan="5" style="background-color:white">
                                            <xsl:value-of select="@Source" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="left" colspan="5" style="background-color:white">
                                            <xsl:value-of select="@Description" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
