﻿/*
 * This is the RAID Manager toc file.
 *
 * !!! Please read the following before modifying this file !!!
 *
 * To add/modify an entry in the toc, just edit the values of the variables in Section 1.
 * Each toc entry consists of two variables: the first containing the description (i.e var txx),
 * the second the corresponding link (i.e. var pxx). For a new (sub)folder "#" must be entered.
 * For translation, only change the description.
 *
 * To modify/add/delete the library structure itself, just alter the "Menu" in Section2.
 * The structure is self explaining.
 * If you need more information please see http://www.cs.ucla.edu/~heng/JSCookTree/tutorial.html
 *
 * Note: This file is also used by a script (HtmManFromToc.js) to generate the pdf manual.
 * Therefore the syntax of this file may not be changed unless you will adjust the parser too.
 * To ensure that the entries in Section 1 will be parsed correctly they MUST look like:
 *
 * var varname <equal><blank><quote><text><quote><semicolon>
 *
 * Anywhere else only blanks are allowed to the right of "="
 *
 * The order of the entries in Section 1 MUST be the same as in Section 2 otherwise
 * the order in "contents" of the pdf manual will be different.
 *
 * If you want to exclude a document from pdf manual,
 * ENTER the link manually in Section2 instead of using varibles in Section 1
 *
 */

/*
 * Section 1 - Definitions
 */
var t01 = 'Notions de base';										// Basics
var p01 = '#';
var t02 = 'Niveaux RAID pris en charge';							// Supported RAID Levels
var p02 = 'supported_raid_types.htm';
var t03 = 'Fonctions de contrôleur RAID';							// RAID Controller Functions
var p03 = 'raid_controller_features.htm';
var t04 = 'Contrôleurs et périphériques pris en charge';			// Supported Controllers and Devices
var p04 = 'supported_controllers_and_devices.htm';

var t10 = 'Connexion';												// Login
var p10 = '#';
var t11 = 'Installation';											// Installation
var p11 = 'installation.htm';
var t12 = 'Connexion';												// Login
var p12 = 'login.htm';
var t13 = 'Certificat de sécurité';									// Security Certificate
var p13 = 'installing_a_security_certificate.htm';
var t14 = 'Conditions requises';									// System requirements
var p14 = 'requirements.htm';
var t15 = 'Licences';												// Licenses
var p15 = 'licenses.htm';

var t20 = "L'interface utilisateur";								// The User Interface
var p20 = '#';
var t21 = "Eléments de l'interface utilisateur";					// Elements of the User Interface
var p21 = 'structure.htm';
var t22 = "Indicateurs et icônes d'état des événements";			// Event Status Indicators and Icons
var p22 = 'icons_and_symbols.htm';

var t30 = 'Propriétés';												// Properties
var p30 = '#';
var t31 = 'Affichage et modification des propriétés';				// Displaying and Modifying Properties
var p31 = 'properties.htm';

var t40 = 'Actions et boîtes de dialogue';							// Actions and Dialogs
var p40 = '#';
var t41 = 'Exécution des actions';									// Executing Actions
var p41 = 'actions.htm';
var t42 = 'Création de lecteurs logiques';							// Creating Logical Drives
var p42 = 'creating_arrays.htm';
var t43 = 'Modification des lecteurs logiques';						// Modifying Logical Drives
var p43 = 'modifying_arrays.htm';
var t44 = 'Traitement des disques de secours';						// Processing Hot Spares // Gérer le disque de secours
var p44 = 'creating_and_deleting_hot_spares.htm';
var t45 = 'Gérer la configuration étrangère';						// Manage Foreign Configuration
var p45 = 'foreign_configuration.htm';
var t46 = 'Gérer la tâche';											// Manage Task
var p46 = 'tasks.htm';

var t50 = 'Evénements';												// Events
var p50 = '#';
var t51 = 'Affichage des événements';								// Displaying Events
var p51 = 'viewing_events.htm';
var t52 = 'Evénements / traps SNMP';								// Events / SNMP Traps
var p52 = 'traps.htm';
var t53 = 'Erreurs';												// Errors
var p53 = 'errors.htm';

var t60 = 'Aide';													// Help
var p60 = '#';
var t61 = 'Aide';													// Help
var p61 = 'help.htm';
var t62 = 'Aide en ligne';											// Online Help
var p62 = 'welcome.htm';
var t63 = 'Interface en ligne de commande';							// Command Line Interface
var p63 = 'amCLI.htm';
var t64 = 'Foire aux questions';									// Frequently Asked Questions
var p64 = 'faqs.htm';

/*
 * Section 2 - toc structure
 */

var Menu =
[
        // first entry will be excluded from printed manual!
        [null,'Aide en ligne','welcome.htm','right',null],

        [null,t01,null,null,null,               // Basics                   // a folder item
                [null,t02,p02,'right',null],    // Supported RAID Types     // a menu item
                [null,t03,p03,'right',null],
                [null,t04,p04,'right',null]
        ],                                                                  // folder item end
       [null,t10,null,null,null,                // Login
                [null,t11,p11,'right',null],    // Installation
                [null,t12,p12,'right',null],    // Login
                [null,t13,p13,'right',null],    // Security Certificate
                [null,t14,p14,'right',null],    // Requirements
                [null,t15,p15,'right',null]     // Licenses
        ],
        [null,t20,null,null,null,               // The User Interface
        		[null,t21,p21,'right',null],    // Structure
        		[null,t22,p22,'right',null]     // Icons and Symbols
        ],
        [null,t30,null,null,null,               // Properties
                [null,t31,p31,'right',null]
        ],
        [null,t40,null,null,null,               // Actions and Dialogs
                [null,t41,p41,'right',null],    // Executing Actions
                [null,t42,p42,'right',null],    // Create array
                [null,t43,p43,'right',null],    // Modify array         
                [null,t44,p44,'right',null],    // Managing spares
                [null,t45,p45,'right',null],    // Handle foreign configurations
                [null,t46,p46,'right',null]     // Manage tasks
        ],
        [null,t50,null,null,null,               // Events
                [null,t51,p51,'right',null],    // Display
                [null,t52,p52,'right',null],    // Traps
                [null,t53,p53,'right',null]     // Errors

        ],
                [null,t60,null,null,null,       // Help
         	    [null,t61,p61,'right',null],    // Help
                [null,t62,p62,'right',null],    // Welcome
                [null,t63,p63,'right',null],    // CLI
                [null,t64,p64,'right',null]     // FAQs
        ],

        // last entry will be excluded from printed manual!
        [null,'Afficher le manuel au format PDF','manual.pdf','extern',null]
];